varying vec2 		texcoord;	
uniform sampler2D 	tex;
varying float		vertexLum;
uniform vec4		lightColor;

#ifdef LIGHTCUBE
	uniform samplerCube	lightCube;
	varying vec3		dist,
				cubeProj;
#else
	uniform sampler2D	lightTex,
				lightFallof;
	varying vec2		Zproj;
	varying vec4		XYproj;	
#endif

void main()
{

#ifdef LIGHTCUBE
	// compute attenuation
	vec4 cube=textureCube(lightCube,cubeProj.xyz);
	vec3 d=dist*2.0-1.0;
	float lum=clamp( (1.0 - dot(d,d)) ,0.0,1.0);
	vec4 att=cube*lum;
#else
	// compute attenuation
	vec4 proj=texture2DProj(lightTex,XYproj);
	vec4 fallof=texture2D(lightFallof,Zproj.st);
	vec4 att=proj*fallof;
#endif
	
	// compute diffuse lighting
	vec4 decal=texture2D(tex,texcoord.st);

	// output color
	gl_FragColor=att*lightColor*decal*vertexLum;
}